
@extends('layouts.admin')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-9 main-dash-left">
            <div class="upper-main-user-navigation">
                <div class="user-manage">
                    <a href="{{ route('admin.booking.index') }}">Booking Management</a>
                    <a class="active" href="">Edit Booking Details</a>
                </div>
            </div>

            <div class="add-user-form">
                <h3>Edit Booking <span class="ms-3"></span></h3>
                
                <form method="POST" action="{{ route('admin.update.booking.detail', $booking->id) }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-1">
                            <div class="comn-input-select">
                                <label for="inputtitle" class="form-label">Title</label>
                                <select id="inputtitle" name="title" class="form-select">
                                    <option value="Mr." {{ str_contains(optional($booking->userDetails)->first_name, 'Mr.') ? 'selected' : '' }}>Mr.</option>
                                    <option value="Mrs." {{ str_contains(optional($booking->userDetails)->first_name, 'Mrs.') ? 'selected' : '' }}>Mrs.</option>
                                    <option value="Ms." {{ str_contains(optional($booking->userDetails)->first_name, 'Ms.') ? 'selected' : '' }}>Ms.</option>
                                    <option value="Dr." {{ str_contains(optional($booking->userDetails)->first_name, 'Dr.') ? 'selected' : '' }}>Dr.</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-5">
                            <div class="comn-input-select">
                                <label for="first-name" class="form-label">First Name</label>
                                <input type="text" class="form-control" id="first-name" name="first_name"
                                    value="{{ optional($booking->userDetails)->first_name }}" required>
                                @error('first_name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="last-name" class="form-label">Last Name</label>
                                <input type="text" class="form-control" id="last-name" name="last_name"
                                    value="{{ optional($booking->userDetails)->last_name }}" required>
                                @error('last_name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress" class="form-label">Street, house number:</label>
                                <input type="text" class="form-control" id="inputAddress" name="address"
                                    value="{{ optional($booking->userDetails)->address }}" required>
                                @error('address')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputAddress2" class="form-label">Zip Code</label>
                                <input type="text" class="form-control" id="inputAddress2" name="zip"
                                    value="{{ optional($booking->userDetails)->zip }}" required>
                                @error('zip')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputCity" class="form-label">City</label>
                                <input type="text" class="form-control" id="inputCity" name="city"
                                    value="{{ optional($booking->userDetails)->city }}" required>
                                @error('city')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputState" class="form-label">Country</label>
                                <select id="inputState" name="country" class="form-select" required>
                                    <option value="">Choose...</option>
                                    <option value="Germany" {{ old('country', $booking->userDetails->country) == 'Germany' ? 'selected' : '' }}>Germany</option>
                                    <option value="Austria" {{ old('country', $booking->userDetails->country) == 'Austria' ? 'selected' : '' }}>Austria</option>
                                    <option value="Switzerland" {{ old('country', $booking->userDetails->country) == 'Switzerland' ? 'selected' : '' }}>Switzerland</option>
                                </select>
                                    @error('country')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="email-address" class="form-label">Email Address</label>
                                <input type="email" class="form-control" id="email-address" name="email"
                                    value="{{ optional($booking->userDetails)->email }}" required>
                                @error('email')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="comn-input-select">
                                <label for="inputZip" class="form-label">Phone Number</label>
                                <div class="numer-input d-flex">
                                    @php
                                        $phone = optional($booking->userDetails)->phone;
                                        $phoneCode = '+49';
                                        $phoneNumber = $phone;
                                        
                                        if ($phone && str_starts_with($phone, '+')) {
                                            $phoneCode = substr($phone, 0, 3);
                                            $phoneNumber = substr($phone, 3);
                                        }
                                    @endphp
                                    
                                    <select id="phone_code" name="phone_code" class="form-select country_code_custom">
                                        <option value="+49" data-image="https://flagcdn.com/16x12/de.png" {{ $phoneCode == '+49' ? 'selected' : '' }}>+49</option>
                                        <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ $phoneCode == '+43' ? 'selected' : '' }}>+43</option>
                                        <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" {{ $phoneCode == '+41' ? 'selected' : '' }}>+41</option>
                                    </select>

                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="{{ $phoneNumber }}" required>
                                </div>
                                @error('phone_code')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                                @error('phone')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="comn-input-select">
                                <label for="note-main" class="form-label">Note</label>
                                <input type="text" class="form-control" id="note-main" name="notes"
                                    placeholder="Enter Note" value="{{ $booking->notes ?? '' }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-5">
                        <h4 class="booking-item-h">Prefered Time Functionality <span class="ms-3">Booking ID : #{{ $booking->id }}</span></h4>
                        
                        <div class="booking-items-container">
                            @foreach($booking->items as $item)
                            <div class="booking-item-card mb-4 p-3 border rounded" data-item-id="{{ $item->id }}">
                                <div class="row">
                                    <div class="col-md-3">
                                        <img src="{{ $item->product->images->first() ? asset('storage/' . $item->product->images->where('type','home')->first()->image_path) : asset('frontend/images/roof1.jpg') }}"
                                                        alt="{{ $item->product_name }}" class="img-fluid" />
                                    </div>
                                    <div class="col-md-9">
                                        <h5>{{ $item->product_name }} | {{ $item->size }}</h5>
                                        
                                        <div class="previous-booking-details mb-3 p-2 bg-light rounded">
                                            <h6>Current Booking:</h6>
                                            <p>
                                                Pickup: {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} / {{ \Carbon\Carbon::parse($item->pickup_time)->format('H:i')}}<br>
                                                Dropoff: {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }} / {{ \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') }}
                                            </p>
                                        </div>
                                        
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Pickup Date</label>
                                                    <input type="text" 
                                                           class="form-control pickup-date flatpickr" 
                                                           data-item-id="{{ $item->id }}"
                                                           placeholder="Select Pickup Date"
                                                           data-default-date="{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}">
                                                    <input type="hidden" 
                                                           name="items[{{ $item->id }}][pickup_date]" 
                                                           value="{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}">
                                                    @error("items.{$item->id}.pickup_date")
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Pickup Time</label>
                                                    <select name="items[{{ $item->id }}][pickup_time]" class="form-control pickup-time" data-item-id="{{ $item->id }}" disabled>
                                                        <option value="">Select date first</option>
                                                    </select>
                                                    @error("items.{$item->id}.pickup_time")
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Dropoff Date</label>
                                                    <input type="text" 
                                                           class="form-control dropoff-date flatpickr" 
                                                           data-item-id="{{ $item->id }}"
                                                           placeholder="Select Dropoff Date"
                                                           data-default-date="{{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }}">
                                                    <input type="hidden" 
                                                           name="items[{{ $item->id }}][dropoff_date]" 
                                                           value="{{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }}">
                                                    @error("items.{$item->id}.dropoff_date")
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Dropoff Time</label>
                                                    <select name="items[{{ $item->id }}][dropoff_time]" class="form-control dropoff-time" data-item-id="{{ $item->id }}" disabled>
                                                        <option value="">Select date first</option>
                                                    </select>
                                                    @error("items.{$item->id}.dropoff_time")
                                                        <div class="text-danger">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group mt-3">
                                            <label>Change Reason (Optional)</label>
                                            <textarea name="items[{{ $item->id }}][change_reason]" class="form-control " style="font-size: 16px" rows="2">{{ old("items.$item->id.change_reason", $item->change_reason) }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    
                    <div class="col-12">
                        <div class="upper-main-btn-last-comn d-flex">
                            <button type="submit" class="add-user">Update Booking</button>
                            <a href="{{ route('admin.booking.index') }}" class="cancel-btn">Back</a>
                        </div>
                    </div>
                </form>

                <div class="return-block">
                    <h3>Return Related Functionalities </h3>
                    @php
                        $hasAlreadyBooked = $booking->items->contains(function($item) {
                            return !empty($item->already_booked) && $item->already_booked == true;
                        });
                    @endphp
                    @if($hasAlreadyBooked)
                        <p style="color: red;">A booking has already been made against this booking . To avoid issues kindly check it. </p>
                    @endif

                    <form method="POST" class="cu-common-form" action="{{ route('admin.update.booking.returnDetail', $booking->id) }}">
                        @csrf
                    
                        <div class="row">
                            <div class="col-md-12">
                                <div class="comn-input-select">
                                    <label for="damaged_item" class="form-label">Damaged</label>
                                    <select id="damaged_item" name="damaged_items[]" class="form-select" multiple>
                                        <option></option> 
                                        @foreach($booking->items as $item)
                                            <option 
                                                value="{{ $item->id }}" 
                                                data-product-name="{{ $item->product_name }}" 
                                                data-product-days="{{ $item->days }}"
                                                @if($item->damage) selected @endif
                                            >
                                                {{ $item->product_name }} - {{ $item->size }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="comn-input-select">
                                    <label for="delay" class="form-label">Delay:</label>
                                    <select id="delay" name="delay" class="form-select">
                                        <option value="0" {{ $booking->delay == 0 ? 'selected' : '' }}>No</option>
                                        <option value="1" {{ $booking->delay == 1 ? 'selected' : '' }}>Yes</option>
                                    </select>
                                </div>
                            </div>
                            <div id="delay_fields" class="row" style="display: {{ $booking->delay ? 'block' : 'none' }};">
                            <div class="col-md-12">
                                <div class="comn-input-select">
                                    <label for="delayed_item" class="form-label">Delay For Products</label>
                                    <select id="delayed_item" name="delayed_item" class="form-select" multiple>
                                        <option></option> 
                                        @foreach($booking->items as $item)
                                            <option 
                                                value="{{ $item->id }}" 
                                                data-product-name="{{ $item->product_name }}" 
                                                data-product-days="{{ $item->days }}"
                                                 data-related-item="{{ $item->related_item }}"
                                                 data-roof-rack = "{{$item->is_roof_rack_product}}"
                                                @if($item->delay) selected @endif
                                            >
                                                {{ $item->product_name }} - {{ $item->size }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                    
                            
                            
                            <div class="col-md-6 comn-input-select">
                                <label for="rental_from" class="form-label">New DropOff Date</label>
                                @php
                                    $defaultDropoffDate = $booking->new_dropoff_date 
                                        ? \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y')
                                        : ($item->dropoff_date 
                                            ? \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') 
                                            : '');
                                @endphp
                                <input type="text" 
                                    class="form-control new_dropoff rental_from" 
                                    data-item-id="{{ $item->id }}"
                                    placeholder="Select New Drop Off Date"
                                    data-default-date="{{ $defaultDropoffDate }}">
                         
                                <input type="hidden" 
                                        name="new_dropoff"
                                        value="{{ $defaultDropoffDate }}">
                              
                               
                            </div>
                            <div class="col-md-6 comn-input-select">
                                <div class="form-group">
                                    <label>New Drop Off Time</label>
                                    <select name="new_dropoff_time" 
                                            class="form-control new_dropoff_time" 
                                            data-selected-time="{{ $item->new_dropoff_time }}"
                                            disabled>
                                        <option value="">Select date first</option>
                                    </select>
                                   
                                </div>
                            </div>


                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Pickup Date</label>
                                        
                                        @error("items.{$item->id}.pickup_date")
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                               
                            </div>
                    
                            <div class="col-md-12 d-flex align-items-center mt-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="delay_fee_checkbox" name="delay_fee_checkbox" value="1"
                                    {{ $booking->delay ? 'checked' : '' }}>
                                    <label class="form-check-label" for="delay_fee_checkbox">
                                        Apply Delay Fee
                                    </label>
                                </div>
                            </div>
                    
                            <div class="col-md-12 mt-5">
                                <div class="comn-input-select col-md-6">
                                <label for="delay_fee" class="form-label">Delay Fee Amount (€)</label>
                                <input type="number" class="form-control" id="delay_fee" name="delay_fee" 
                                step="0.01" min="0" value="{{ $booking->delay_fees }}">
                                </div>
                            </div>
                    
                            <div class="col-md-12 mt-3">
                                <div class="comn-input-select col-md-6">
                                <label for="additional_days" class="form-label">Additional Rental Days</label>
                                <input type="number" class="form-control" id="additional_days" name="additional_days" 
                                    min="0" value="{{ $booking->additional_days }}">
                                </div>
                            </div>
                    
                        </div>

                        </div>
                        @php
                            $subtotal = 0;
                            
                            $netPrice = 0;
                          
                            $tax = 0;
                            $total = 0; 
                        @endphp
                            <div class="sub_heading_18">Cart Totals</div>
                            <div class="comm_detail_list_view cart_total_list">
                                <div class="comm_detail_list_col">
                                    <h5>Subtotal</h5>
                                    <h6 id="cart_sub_total">{{ number_format($subtotal, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col">
                                    <h5>Delay Fees</h5>
                                    <h6 id="delay_fees">{{ number_format($netPrice, 2, ',', '') }} €</h6>
                                </div>
                               
                                <div class="comm_detail_list_col">
                                    <h5>Net Price</h5>
                                    <h6 id="net_price">{{ number_format($netPrice, 2, ',', '') }} €</h6>
                                </div>
                               
                                <div class="comm_detail_list_col">
                                    <h5>Tax (19%)</h5>
                                    <h6 id="tax">{{ number_format($tax, 2, ',', '') }} €</h6>
                                </div>
                                <div class="comm_detail_list_col bott_total_row">
                                    <h5>Total</h5>
                                    <h6 id="totalRow"></h6>
                                </div>
                            </div>
                            <input type="hidden" name="subtotal" id="subtotal_input">
                            <input type="hidden" name="delay_fees_value" id="delay_fees_input">
                            <input type="hidden" name="net_price" id="net_price_input">
                            <input type="hidden" name="tax" id="tax_input">
                            <input type="hidden" name="total" id="total_input">
                            <input type="hidden" name="return_booking_id" id="return_booking_id" value="{{ $booking->id }}">

                            <input type="hidden" name="additional_days_rent" id="additional_days_rent" value="">

                            {{ \Carbon\Carbon::parse($booking->last_delay_payment_link_sent_at)->format('d.m.y H:i') }}
                            <p style="font-size: 12px">For resending the paymentlink please click on the "Update Return Information" This can be done without adjustments on the page.</p>
                            <div class="col-md-12 mt-4">
                                <button type="submit" class="add-user">
                                    Update Return Information
                                </button>
                            </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>





<div class="modal fade modal-delete-logout" id="syncItemsModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="syncItemsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="syncItemsModalLabel" class="mb-3">Synchronize Dates/Times</h4>
                    <p id="delete-description" class=" mb-0"> Do you want to update the pickup and dropoff date and time for all related items in this group as well?</p>
                    <div class="upper-btns-modal-pair">
                        <button type="button" id="syncItemsModalYes" class="comn-modal-btns-blue btn btn-primary">Yes</button>
                        <button type="button" id="syncItemsModalNo" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .flatpickr-input {
        background-color: white;
        cursor: pointer;
    }
    .booking-item-card {
        background-color: #f8f9fa;
        transition: all 0.3s ease;
    }
    .booking-item-card:hover {
        background-color: #e9ecef;
    }
    .previous-booking-details {
        font-size: 0.9rem;
    }
    .text-danger {
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
</style>

<script>
    let itemData = {!! json_encode($booking->items->map(function($item) {
        return ['id' => $item->id, 'related_item' => $item->related_item];
    })) !!};

    let pendingSync = null;
    let syncInProgress = false;

    function getGroupIds(changedId) {
        let main = itemData.find(i => i.id == changedId);
        if (!main) return [];
        let parentId = main.related_item ? main.related_item : main.id;
        let group = itemData.filter(i => (i.related_item == parentId || i.id == parentId)).map(i => i.id);
        return group;
    }

    function parseDate(dateStr) {
        const parts = dateStr.split('.');
        if (parts.length === 3) {
            return parts[2] + '-' + parts[1].padStart(2, '0') + '-' + parts[0].padStart(2, '0');
        }
        return dateStr;
    }

    $('#delay').on('change', function() {
        if ($(this).val() === '1') {
            $('#delay_fields').slideDown();
        } else {
            $('#delay_fields').slideUp();
        }
    });

    if ($('#delay').val() === '1') {
        $('#delay_fields').show();
    } else {
        $('#delay_fields').hide();
    }
    var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
    
    $(document).ready(function() {
        let dailyPriceMap = {}; 
      
        $('#damaged_item').select2({
            placeholder: "Select damaged item(s)",
            allowClear: true,
            width: '100%'
        });
        $('#delayed_item').select2({
            placeholder: "Select delayed item(s)",
            allowClear: true,
            width: '100%'
        });

        $('#damaged_item').on('change', function() {
            let selectedIds = $(this).val() || [];

            if (!Array.isArray(selectedIds)) {
                selectedIds = [selectedIds];
            }

            if (selectedIds.length === 0) {
                calculateRent();
                return;
            }

            let requests = [];
            dailyPriceMap = {}; 

            selectedIds.forEach(id => {
                let productName = $(`#damaged_item option[value="${id}"]`).data('product-name');

                requests.push(
                    $.get(`${baseUrl}/admin/dailyPrice/product`, { productName }, function(data) {
                        dailyPriceMap[id] = data;
                    })
                );
            });

            $.when.apply($, requests).done(function() {
                calculateRent();
            });
        });

        $('#delayed_item').on('change', function() {
            let selectedIds = $(this).val() || [];

            if (!Array.isArray(selectedIds)) {
                selectedIds = [selectedIds];
            }

            if (selectedIds.length === 0) {
                calculateRent();
                return;
            }

            let requests = [];
            dailyPriceMap = {}; 

            selectedIds.forEach(id => {
                let productName = $(`#delayed_item option[value="${id}"]`).data('product-name');
                let relatedItem = $(`#delayed_item option[value="${id}"]`).data('related-item');
                let roofRackProduct = $(`#delayed_item option[value="${id}"]`).data('roof-rack');

                if (relatedItem ) {
                    productName = "Dachträger ergänzt zu Dachbox/ Dachfahrradträger";
                } else {
                    productName = productName;
                }

                if(roofRackProduct){
                    productName = '';
                }
                if(productName){

                    requests.push(
                        $.get(`${baseUrl}/admin/dailyPrice/product`, { productName }, function(data) {
                            dailyPriceMap[id] = data;
                        })
                    );
                }
            });

            $.when.apply($, requests).done(function() {
                calculateRent();
            });
        });

        $('#additional_days, #delay_fee, #delay_fee_checkbox').on('input change', function() {
            calculateRent();
        });

        function calculateRent() {
            let selectedIds =  $('#delayed_item').val() || [];

            if (!Array.isArray(selectedIds)) {
                selectedIds = [selectedIds];
            }

            let additionalDays = parseInt($('#additional_days').val() || 0, 10);
            let total = 0;
            let subtotal = 0;

            selectedIds.forEach(id => {
                let oldDays =  parseInt($(`#delayed_item option[value="${id}"]`).data('product-days') || 0, 10);
                let totalDays = oldDays + additionalDays;
                let prices = dailyPriceMap[id] || [];

                for (let i = oldDays + 1; i <= totalDays && i < prices.length; i++) {
                    total += parseFloat(prices[i] || 0);
                    subtotal += parseFloat(prices[i] || 0);
                }
            });
            $('#additional_days_rent').val(total);

           
            let tax = subtotal - (subtotal/1.19);
            subtotal = subtotal / 1.19;
            let netPrice = subtotal; 
            
            if ($('#delay_fee_checkbox').is(':checked')) {
                total += parseFloat($('#delay_fee').val() || 0);
                netPrice += parseFloat($('#delay_fee').val() / 1.19 || 0);
                tax += parseFloat($('#delay_fee').val() || 0) - parseFloat($('#delay_fee').val() / 1.19 || 0);
            }

            $('#subtotal_input').val(subtotal.toFixed(2));
            $('#delay_fees_input').val(parseFloat($('#delay_fee').val() || 0).toFixed(2));
            $('#net_price_input').val(netPrice.toFixed(2));
            $('#tax_input').val(tax.toFixed(2));
            $('#total_input').val(total.toFixed(2));

            $('#cart_sub_total').text(formatEuro(subtotal));
            $('#totalRow').text(formatEuro(total));
            $('#net_price').text(formatEuro(netPrice));
            $('#tax').text(formatEuro(tax));
            $('#delay_fees').text(formatEuro(parseFloat($('#delay_fee').val() || 0)));
        }

        function formatEuro(amount) {
            return amount.toLocaleString('de-DE', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + ' €';
        }
        if ($('#delayed_item').val() && $('#delayed_item').val().length > 0) {
            $('#delayed_item').trigger('change');
        } else {
            calculateRent();
        }
    });

    $(document).on('change', '.pickup-date,.pickup-time,.dropoff-date,.dropoff-time', function () {
        if (syncInProgress) return;
        
        let $input = $(this);
        let itemId = parseInt($input.data('item-id'));
        let groupIds = getGroupIds(itemId);

        if (groupIds.length > 1) {
            let inputType = '';
            if ($input.hasClass('pickup-date')) inputType = 'pickup-date';
            else if ($input.hasClass('pickup-time')) inputType = 'pickup-time';
            else if ($input.hasClass('dropoff-date')) inputType = 'dropoff-date';
            else if ($input.hasClass('dropoff-time')) inputType = 'dropoff-time';

            pendingSync = {
                itemId: itemId,
                groupIds: groupIds,
                inputType: inputType,
                newValue: $input.val(),
                $triggerInput: $input
            };
            $('#syncItemsModal').modal('show');
        }
    });

    $('#syncItemsModalYes').on('click', function () {
        if (pendingSync) {
            syncInProgress = true;
            
            pendingSync.groupIds.forEach(function (id) {
                if (id == pendingSync.itemId) return;

                let $targetInput = $(`.booking-item-card[data-item-id="${id}"] .${pendingSync.inputType}`);
                if ($targetInput.length) {
                    if (pendingSync.inputType.includes('date')) {
                        let flatpickrInstance = $targetInput[0]._flatpickr;
                        if (flatpickrInstance) {
                            flatpickrInstance.setDate(pendingSync.newValue, true);
                        } else {
                            $targetInput.val(pendingSync.newValue);
                            let hiddenName = pendingSync.inputType === 'pickup-date' ? 
                                `items[${id}][pickup_date]` : `items[${id}][dropoff_date]`;
                            $(`input[name="${hiddenName}"]`).val(pendingSync.newValue);
                            
                            const isPickup = pendingSync.inputType === 'pickup-date';
                            const dateForApi = parseDate(pendingSync.newValue);
                            loadTimeSlots(id, dateForApi, isPickup);
                        }
                    } else if (pendingSync.inputType.includes('time')) {
                        $targetInput.val(pendingSync.newValue).trigger('change');
                    }
                }
            });
            
            syncInProgress = false;
        }
        $('#syncItemsModal').modal('hide');
        pendingSync = null;
    });

    $('#syncItemsModalNo').on('click', function () {
        $('#syncItemsModal').modal('hide');
        pendingSync = null;
    });

    $(document).ready(function() {
        $('.rental_from').flatpickr({
            dateFormat: "d.m.Y",
            minDate: "today",
            disable: [
                function(date) {
                    return (date.getDay() === 0 || date.getDay() === 6);
                }
            ],
            locale: {
                firstDayOfWeek: 1
            },
            defaultDate: $('.new_dropoff').data('default-date'),
            onChange: function(selectedDates, dateStr, instance) {
                const itemId = instance.element.dataset.itemId;
                $(`input[name="new_dropoff"]`).val(dateStr);

                if (dateStr) {
                    loadTimeSlotsDelay(itemId, dateStr);
                } else {
                    const timeSelect = $(`.new_dropoff_time`);
                    timeSelect.html('<option value="">Select date first</option>').prop('disabled', true);
                }
                
                validateDateRange(itemId);
            }
        });

        $('.flatpickr').flatpickr({
            dateFormat: "d.m.Y",
            minDate: "today",
            disable: [
                function(date) {
                    return (date.getDay() === 0 || date.getDay() === 6);
                }
            ],
            locale: {
                firstDayOfWeek: 1
            },
            onChange: function(selectedDates, dateStr, instance) {
                const itemId = instance.element.dataset.itemId;
                const isPickup = instance.element.classList.contains('pickup-date');
                
                $(`input[name="items[${itemId}][${isPickup ? 'pickup' : 'dropoff'}_date]"]`).val(dateStr);
                
                $(`.booking-item-card[data-item-id="${itemId}"] .${isPickup ? 'pickup' : 'dropoff'}-date`).next('.text-danger').remove();
                
                if (dateStr) {
                    loadTimeSlots(itemId, dateStr, isPickup);

                    if (!isPickup) {
                        validateDateRange(itemId);
                    }
                    
                    // If this is a pickup date change, update dropoff minDate
                    if (isPickup) {
                        const dropoffInput = $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`);
                        if (dropoffInput.length) {
                            const dropoffInstance = dropoffInput[0]._flatpickr;
                            if (dropoffInstance) {
                                // Set minDate for dropoff to be at least the pickup date
                                dropoffInstance.set('minDate', selectedDates[0]);
                                
                                // Validate if dropoff date is already selected
                                validateDateRange(itemId);
                            }
                        }
                    }
                } else {
                    const timeSelect = isPickup ? 
                        $(`.booking-item-card[data-item-id="${itemId}"] .pickup-time`) : 
                        $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-time`);
                    timeSelect.html('<option value="">Select date first</option>').prop('disabled', true);
                }
                
                validateDateRange(itemId);
            }
        });
        
        function loadTimeSlots(itemId, date, isPickup) {
            const timeSelect = isPickup ? 
                $(`.booking-item-card[data-item-id="${itemId}"] .pickup-time`) : 
                $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-time`);
                
            timeSelect.prop('disabled', true).html('<option value="">Loading time slots...</option>');
            
            $.ajax({
                url: `${baseUrl}/admin/getTime`,
                type: 'GET',
                data: {
                    date: date,
                    item_id: itemId,
                    is_pickup: isPickup
                },
                success: function(response) {
                    let options = '<option value="">No time selected (keep current)</option>';
                    
                    if (response.slots && response.slots.length > 0) {
                        response.slots.forEach(slot => {
                            const timeValue = slot.label.split(' - ')[0];
                            const disabledAttr = slot.disabled ? 'disabled' : '';
                            
                            options += `<option value="${timeValue}" ${disabledAttr}>${slot.label}</option>`;
                        });
                    }
                    
                    timeSelect.html(options).prop('disabled', false);
                    
                    const previousTime = isPickup ? 
                        "{{ $item->pickup_time }}" : 
                        "{{ $item->dropoff_time }}";
                    if (previousTime) {
                        timeSelect.find('option').each(function() {
                            if ($(this).val() === previousTime) {
                                $(this).prop('selected', true);
                                return false;
                            }
                        });
                    } else {
                        timeSelect.val('');
                    }
                },
                error: function() {
                    timeSelect.html('<option value="">Error loading slots</option>');
                }
            });
        }

        const newDropoffDate = $('input[name="new_dropoff"]').val();
        if (newDropoffDate) {
            const itemId = $('.new_dropoff').data('item-id');
            loadTimeSlotsDelay(itemId, newDropoffDate);
            
            let selectedTime = $('.new_dropoff_time').data('selected-time');
            selectedTime = selectedTime.substring(0,5);
            if (selectedTime) {
                $(document).ajaxStop(function() {
                    $('.new_dropoff_time').val(selectedTime);
                });
            }
        }

        function loadTimeSlotsDelay(itemId, date) {
            const timeSelect = $(`.new_dropoff_time`);
                
            timeSelect.prop('disabled', true).html('<option value="">Loading time slots...</option>');
            
            $.ajax({
                url: `${baseUrl}/admin/getTime`,
                type: 'GET',
                data: {
                    date: date,
                    item_id: itemId,
                },
                success: function(response) {
                    let options = '<option value="">No time selected (keep current)</option>';
                    
                    if (response.slots && response.slots.length > 0) {
                        response.slots.forEach(slot => {
                            const timeValue = slot.label.split(' - ')[0];
                            const disabledAttr = slot.disabled ? 'disabled' : '';
                            
                            options += `<option value="${timeValue}" ${disabledAttr}>${slot.label}</option>`;
                        });
                    }
                    
                    timeSelect.html(options).prop('disabled', false);
                    const selectedTime = timeSelect.data('selected-time');
                    if (selectedTime) {
                        timeSelect.val(selectedTime);
                    } else {
                        timeSelect.val('');
                    }
                    
                },
                error: function() {
                    timeSelect.html('<option value="">Error loading slots</option>');
                }
            });
        }
        
        function validateDateRange(itemId) {
            const pickupDateStr = $(`input[name="items[${itemId}][pickup_date]"]`).val();
            const dropoffDateStr = $(`input[name="items[${itemId}][dropoff_date]"]`).val();
            
            // Remove any existing error messages
            $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`).next('.text-danger').remove();
            $(`.booking-item-card[data-item-id="${itemId}"] .pickup-date`).next('.text-danger').remove();
            
            if (pickupDateStr && dropoffDateStr) {
                // Convert date strings to Date objects (format: d.m.Y)
                const pickupParts = pickupDateStr.split('.');
                const dropoffParts = dropoffDateStr.split('.');
                
                const pickupDate = new Date(pickupParts[2], pickupParts[1] - 1, pickupParts[0]);
                const dropoffDate = new Date(dropoffParts[2], dropoffParts[1] - 1, dropoffParts[0]);
                
                if (dropoffDate < pickupDate) {
                    const errorDiv = $('<div class="text-danger">Dropoff date must be after pickup date</div>');
                    $(`.booking-item-card[data-item-id="${itemId}"] .dropoff-date`).after(errorDiv);
                    return false;
                }
            }
            return true;
        }
        
        @foreach($booking->items as $item)
            @if($item->pickup_date)
                loadTimeSlots("{{ $item->id }}", "{{ \Carbon\Carbon::parse($item->pickup_date)->format('Y-m-d') }}", true);
            @endif
            @if($item->dropoff_date)
                loadTimeSlots("{{ $item->id }}", "{{ \Carbon\Carbon::parse($item->dropoff_date)->format('Y-m-d') }}", false);
            @endif
        @endforeach
    });

    
    
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
@endsection
